/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.spectrum.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.grits.toolbox.display.control.spectrum.chart.GRITSChartComposite;
import org.grits.toolbox.display.control.spectrum.datamodel.AnnotationGrid;
import org.grits.toolbox.utils.image.GlycanImageProvider;
import org.grits.toolbox.utils.image.SimianImageConverter;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.AbstractXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class GRITSXYPlot
extends XYPlot {
    private static final long serialVersionUID = -4472476666893443246L;
    protected Rectangle2D dataArea = null;
    protected PlotRenderingInfo info = null;
    protected AnnotationGrid grid = null;
    protected HashMap<Double, double[]> htItemsToBestInt = null;
    protected HashMap<Double, XYAnnotation> htItemsToLineAnnotation = null;
    protected HashMap<Double, List<Object>> htPostPaintPeakLabels;
    protected boolean bDrawPostPaintAnnotations = false;
    protected HashMap<Double, Object>[] htPeakLabels;
    protected double dChartScale = 1.0;
    protected int iChartWidth = -1;
    protected int iChartHeight = -1;
    protected static final float[] dash1 = new float[]{10.0f};
    protected static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    protected HashMap<Object, int[]> htAnnotationToCoords = null;

    public GRITSXYPlot(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer, HashMap<Double, List<Object>> htPostPaintPeakLabels) {
        super(dataset, domainAxis, rangeAxis, renderer);
        this.htPostPaintPeakLabels = htPostPaintPeakLabels;
        this.htPeakLabels = new HashMap[4];
    }

    public GRITSXYPlot() {
        this.htPeakLabels = new HashMap[4];
    }

    public void setChartHeight(int iChartHeight) {
        this.iChartHeight = iChartHeight;
    }

    public int getChartHeight() {
        return this.iChartHeight;
    }

    public void setChartWidth(int iChartWidth) {
        this.iChartWidth = iChartWidth;
    }

    public int getChartWidth() {
        return this.iChartWidth;
    }

    public void setChartScale(double dChartScale) {
        this.dChartScale = dChartScale;
    }

    public double getChartScale() {
        return this.dChartScale;
    }

    public void setPeakLabels(int iSeriesInx, HashMap<Double, Object> htPeakLabels) {
        if (iSeriesInx < 0 || iSeriesInx >= this.htPeakLabels.length) {
            return;
        }
        this.htPeakLabels[iSeriesInx] = htPeakLabels;
        XYItemRenderer renderer = this.getRenderer(iSeriesInx);
        renderer.setBaseItemLabelGenerator((XYItemLabelGenerator)new LabelGenerator(iSeriesInx));
        renderer.setBaseItemLabelsVisible(true);
    }

    protected Object getPeakLabel(int _iSeriesInx, double _dPeakMass) {
        if (this.htPeakLabels == null) {
            return "";
        }
        double dMinDelta = Double.MAX_VALUE;
        String sPeakLabel = "";
        for (Double dPeakMass : this.htPeakLabels[_iSeriesInx].keySet()) {
            double delta = Math.abs(dPeakMass - _dPeakMass);
            if (!(delta < dMinDelta) || !(delta < 0.05)) continue;
            sPeakLabel = this.htPeakLabels[_iSeriesInx].get(dPeakMass).toString();
        }
        return sPeakLabel;
    }

    public void setDrawPostPaintAnnotations(boolean bDrawPostPaintAnnotations) {
        this.bDrawPostPaintAnnotations = bDrawPostPaintAnnotations;
    }

    public boolean getDrawPostPaintAnnotations() {
        return this.bDrawPostPaintAnnotations;
    }

    public void setPostPaintAnnotations(HashMap<Double, List<Object>> htPostPaintPeakLabels) {
        this.htPostPaintPeakLabels = htPostPaintPeakLabels;
    }

    public void setDataArea(Rectangle2D dataArea) {
        this.dataArea = dataArea;
    }

    public void setPlotRenderingInfo(PlotRenderingInfo info) {
        this.info = info;
    }

    protected void initializeGrid(int iCellWidth, int iCellHeight, double dScaleX, double dScaleY) {
        this.grid = new AnnotationGrid(this, this.dataArea, this.getDomainAxis(), this.getRangeAxis(), dScaleX, dScaleY);
        this.grid.initializeGrid(iCellWidth, iCellHeight);
    }

    public void initAnnotationGrid(double dMassDelta) {
        this.htItemsToBestInt = new HashMap();
        if (this.htPostPaintPeakLabels == null) {
            return;
        }
        PlotOrientation orientation = this.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation((AxisLocation)this.getDomainAxisLocation(), (PlotOrientation)orientation);
        int iDScount = 0;
        while (iDScount < this.getDatasetCount()) {
            XYDataset dataset = this.getDataset(iDScount);
            int series = 0;
            while (series < dataset.getSeriesCount()) {
                int item = 0;
                while (item < dataset.getItemCount(series)) {
                    double[] vals = new double[]{dataset.getXValue(series, item), dataset.getYValue(series, item)};
                    double dx = this.getDomainAxis().valueToJava2D(vals[0], this.dataArea, domainEdge);
                    if (dx > 0.0) {
                        for (Double dPeakMass : this.htPostPaintPeakLabels.keySet()) {
                            double delta = Math.abs(dPeakMass - vals[0]);
                            if (!(delta < dMassDelta)) continue;
                            double dPrevInt = 0.0;
                            if (this.htItemsToBestInt.containsKey(dPeakMass)) {
                                dPrevInt = this.htItemsToBestInt.get(dPeakMass)[1];
                            }
                            if (!(dPrevInt < vals[1]) && delta != 0.0) continue;
                            this.htItemsToBestInt.put(dPeakMass, vals);
                        }
                    }
                    ++item;
                }
                ++series;
            }
            ++iDScount;
        }
    }

    public HashMap<Object, int[]> getHtAnnotationToCoords() {
        return this.htAnnotationToCoords;
    }

    protected boolean drawPostPaintAnnotation(Graphics2D g2, GRITSChartComposite chart, Double dPeakMass, List<Object> alAnnots, boolean bForceStacking) {
        double dScaleX = chart.getScaleX();
        double dScaleY = chart.getScaleY();
        double[] vals = this.htItemsToBestInt.get(dPeakMass);
        AnnotationGrid.AnnotationCell cellDP = this.grid.getNewCell(vals[0], vals[1]);
        if (cellDP == null) {
            return true;
        }
        int iLineDPX = (int)((double)cellDP.getScreenLowX() * dScaleX);
        int iLineDPY = (int)((double)cellDP.getScreenLowY() * dScaleY);
        int iLineMinX = Integer.MAX_VALUE;
        int iLineMaxX = Integer.MIN_VALUE;
        int iLineMaxY = Integer.MIN_VALUE;
        this.htAnnotationToCoords = new HashMap();
        int iPrefX = -1;
        for (Object oPeakAnnotation : alAnnots) {
            AnnotationGrid.AnnotationCell cell = this.grid.putAnnotation(oPeakAnnotation, vals[0], vals[1], iPrefX);
            if (cell == null && iPrefX != -1) {
                cell = this.grid.putAnnotation(oPeakAnnotation, vals[0], vals[1], -1);
            }
            if (cell == null) continue;
            int iCellX = (int)((double)cell.getScreenLowX() * dScaleX);
            int iCellX2 = (int)((double)cell.getScreenLowX() * dScaleX);
            int iCellY = (int)((double)cell.getScreenLowY() * dScaleY);
            int iCellY2 = (int)((double)cell.getScreenLowY() * dScaleY);
            if (bForceStacking && iPrefX != -1 && iPrefX != (int)cell.getScreenLowX()) {
                return false;
            }
            if (oPeakAnnotation instanceof GlycanImageProvider.GlycanImageObject) {
                GlycanImageProvider.GlycanImageObject gio = (GlycanImageProvider.GlycanImageObject)oPeakAnnotation;
                double dScaleValX = this.grid.getCellWidth() * this.grid.getScaleX();
                double dScaleValY = this.grid.getCellHeight() * this.grid.getScaleY();
                gio.dispose();
                BufferedImage bImg = gio.getScaledAwtBufferedImage(dScaleValX, dScaleValY);
                g2.drawImage(bImg, iCellX, iCellY, bImg.getWidth(), bImg.getHeight(), null);
                iCellY2 += bImg.getHeight();
                iCellX2 += bImg.getWidth();
            }
            if (iCellX2 > iLineMaxX) {
                iLineMaxX = iCellX2;
            }
            if (iCellX < iLineMinX) {
                iLineMinX = iCellX;
            }
            if (iCellY2 > iLineMaxY) {
                iLineMaxY = iCellY2;
            }
            iPrefX = (int)cell.getScreenLowX();
        }
        g2.setStroke(dashed);
        int iMidX = iLineMinX + (iLineMaxX - iLineMinX) / 2;
        Line2D.Float line1 = new Line2D.Float(iLineDPX, iLineDPY, iMidX, iLineMaxY);
        g2.draw(line1);
        g2.drawString(dPeakMass.toString(), iLineMinX, iLineMaxY);
        return true;
    }

    protected void drawPostPaintAnnotations(Graphics2D g2, GRITSChartComposite chart, ValueAxis axis, boolean bForceStacking) {
        if (this.htPostPaintPeakLabels == null || !this.getDrawPostPaintAnnotations()) {
            return;
        }
        ArrayList<Double> sortedKeys = new ArrayList<Double>(this.htItemsToBestInt.keySet());
        Collections.sort(sortedKeys);
        for (Double dPeakMass : sortedKeys) {
            List<Object> alAnnots = this.htPostPaintPeakLabels.get(dPeakMass);
            if (alAnnots == null || this.drawPostPaintAnnotation(g2, chart, dPeakMass, alAnnots, bForceStacking)) continue;
            chart.setGridScale(chart.getGridScale() * 0.75);
            axis.zoomRange(0.0, 1.25);
            return;
        }
    }

    protected void drawPostPaintAnnotations(Graphics2D g2, Rectangle2D dataArea, ValueAxis axis, boolean bForceStacking, boolean bWriteMass) {
        if (this.htPostPaintPeakLabels == null || !this.getDrawPostPaintAnnotations()) {
            return;
        }
        ArrayList<Double> sortedKeys = new ArrayList<Double>(this.htItemsToBestInt.keySet());
        Collections.sort(sortedKeys);
        for (Double dPeakMass : sortedKeys) {
            List<Object> alAnnots = this.htPostPaintPeakLabels.get(dPeakMass);
            if (alAnnots == null || this.drawPostPaintAnnotation(g2, dataArea, dPeakMass, alAnnots, bForceStacking, bWriteMass)) continue;
            axis.zoomRange(0.0, 1.25);
            return;
        }
    }

    public static double getXDatasetDensity(XYDataset xyDataset, int iSeries, Range range) {
        double dMin = Double.MAX_VALUE;
        double dMax = Double.MIN_VALUE;
        int iCnt = 0;
        int i = 0;
        while (i < xyDataset.getItemCount(iSeries)) {
            Double dValue = xyDataset.getXValue(iSeries, i);
            if (!(dValue < range.getLowerBound()) && !(dValue > range.getUpperBound())) {
                ++iCnt;
                if (dValue < dMin) {
                    dMin = dValue;
                }
                if (dValue > dMax) {
                    dMax = dValue;
                }
            }
            ++i;
        }
        double dDensity = (double)iCnt / (dMax - dMin);
        return dDensity;
    }

    public static int[] getNumVisPeaks(XYDataset xyDataset, int iSeries, Range domainAxis, Range rangeAxis) {
        HashMap<Double, Integer> alSeen = new HashMap<Double, Integer>();
        int iYMax = Integer.MIN_VALUE;
        int i = 0;
        while (i < xyDataset.getItemCount(iSeries)) {
            Double dXValue = xyDataset.getXValue(iSeries, i);
            double dYValue = xyDataset.getYValue(iSeries, i);
            if (!(dXValue < domainAxis.getLowerBound() || dXValue > domainAxis.getUpperBound() || dYValue < rangeAxis.getLowerBound() || dYValue > rangeAxis.getUpperBound())) {
                if (!alSeen.containsKey(dXValue)) {
                    alSeen.put(dXValue, 1);
                } else {
                    alSeen.put(dXValue, (Integer)alSeen.get(dXValue) + 1);
                }
                if ((Integer)alSeen.get(dXValue) > iYMax) {
                    iYMax = (Integer)alSeen.get(dXValue);
                }
            }
            ++i;
        }
        double dVal = (domainAxis.getUpperBound() - domainAxis.getLowerBound()) / (double)alSeen.size();
        return new int[]{alSeen.size(), (int)((double)iYMax / (dVal / (double)alSeen.size()))};
    }

    public double getVisPeakFactor(XYDataset xyDataset, int iSeries, Range domainAxis, Range rangeAxis) {
        int iNumVis = 0;
        int i = 0;
        while (i < xyDataset.getItemCount(iSeries)) {
            Double dXValue = xyDataset.getXValue(iSeries, i);
            double dYValue = xyDataset.getYValue(iSeries, i);
            if (!(dXValue < domainAxis.getLowerBound() || dXValue > domainAxis.getUpperBound() || dYValue < rangeAxis.getLowerBound() || dYValue > rangeAxis.getUpperBound())) {
                ++iNumVis;
            }
            ++i;
        }
        double dVal = (double)this.getChartWidth() / (double)iNumVis;
        if (dVal < 0.2) {
            dVal = 0.2;
        }
        if (dVal > 1.0) {
            dVal = 1.0;
        }
        return dVal;
    }

    public double[] getGridCellDimensions(int[] iNumVisPeaks, Range domainAxis, Range rangeAxis, double[] dMaxImgSize) {
        double dRetFactorWidth;
        double dIdealWidth = (double)iNumVisPeaks[0] * (dMaxImgSize[0] + 10.0);
        double dIdealHeight = (double)iNumVisPeaks[1] * (dMaxImgSize[1] + 10.0);
        double dWidthFactor = Math.ceil(dIdealWidth / (double)this.getChartWidth());
        if (dWidthFactor == 1.0) {
            return dMaxImgSize;
        }
        double dHeightFactor = Math.ceil(dIdealHeight / (double)this.getChartHeight());
        double dStackedWidth = (double)iNumVisPeaks[0] / dWidthFactor;
        double dStackedHeight = (double)iNumVisPeaks[1] / dHeightFactor;
        double d = dRetFactorWidth = dStackedWidth < 4.0 ? dStackedWidth : Math.ceil(dStackedWidth / 4.0);
        if (!(dStackedHeight < 4.0)) {
            Math.ceil(dStackedHeight / 4.0);
        }
        double dNewWidth = dMaxImgSize[0] / dRetFactorWidth;
        double dNewHeight = dMaxImgSize[1] / dRetFactorWidth;
        return new double[]{dNewWidth, dNewHeight};
    }

    protected double[] getMaxCellSize() {
        double dMaxW = 80.0;
        double dMaxH = 80.0;
        if (this.htPostPaintPeakLabels == null || !this.getDrawPostPaintAnnotations()) {
            return new double[]{dMaxW, dMaxH};
        }
        ArrayList<Double> sortedKeys = new ArrayList<Double>(this.htPostPaintPeakLabels.keySet());
        Collections.sort(sortedKeys);
        for (Double dPeakMass : sortedKeys) {
            List<Object> alAnnots = this.htPostPaintPeakLabels.get(dPeakMass);
            if (alAnnots == null) continue;
            for (Object oPeakAnnotation : alAnnots) {
                if (!(oPeakAnnotation instanceof GlycanImageProvider.GlycanImageObject)) continue;
                GlycanImageProvider.GlycanImageObject gio = (GlycanImageProvider.GlycanImageObject)oPeakAnnotation;
                gio.dispose();
                BufferedImage bImg = gio.getAwtBufferedImage();
                int iW = bImg.getWidth();
                int iH = bImg.getHeight();
                if ((double)iW > dMaxW) {
                    dMaxW = iW;
                }
                if (!((double)iH > dMaxH)) continue;
                dMaxH = iH;
            }
        }
        return new double[]{dMaxW, dMaxH};
    }

    public void drawGRITSAnnotations(Graphics2D sg2, Rectangle2D dataArea) {
        double dYScale;
        if (this.getDatasetCount() <= 1) {
            return;
        }
        int[] iNumVis = GRITSXYPlot.getNumVisPeaks(this.getDataset(1), 0, this.getDomainAxis().getRange(), this.getRangeAxis().getRange());
        double dVisXDensity = 10.0 * ((double)iNumVis[0] / dataArea.getWidth());
        double dVisYDensity = 15.0 * ((double)iNumVis[1] / dataArea.getHeight());
        double dXScale = 1.0 - dVisXDensity;
        if (dXScale < 0.2) {
            dXScale = 0.2;
        }
        if (dXScale > 1.0) {
            dXScale = 1.0;
        }
        if ((dYScale = 1.0 - dVisYDensity) < 0.2) {
            dYScale = 0.2;
        }
        if (dYScale > 1.0) {
            dYScale = 1.0;
        }
        double[] dMaxCellSizes = this.getMaxCellSize();
        double[] dScaledCellSizes = this.getGridCellDimensions(iNumVis, this.getDomainAxis().getRange(), this.getRangeAxis().getRange(), dMaxCellSizes);
        double dVisPeakFactor = this.getVisPeakFactor(this.getDataset(1), 0, this.getDomainAxis().getRange(), this.getRangeAxis().getRange());
        double cfr_ignored_0 = dMaxCellSizes[0];
        double cfr_ignored_1 = dMaxCellSizes[1];
        this.initializeGrid((int)dScaledCellSizes[0], (int)dScaledCellSizes[1], 0.7, 1.0);
        this.initAnnotationGrid(0.9);
        PlotOrientation orientation = this.getOrientation();
        ValueAxis axis = null;
        axis = orientation == PlotOrientation.VERTICAL ? this.getRangeAxis() : this.getDomainAxis();
        this.drawPostPaintAnnotations(sg2, dataArea, axis, false, dXScale > 0.8);
    }

    public void drawAnnotations(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info) {
        this.dataArea = dataArea;
        this.info = info;
        super.drawAnnotations(g2, dataArea, info);
        this.drawGRITSAnnotations(g2, dataArea);
    }

    protected boolean drawPostPaintAnnotation(Graphics2D g2, Rectangle2D dataArea, Double dPeakMass, List<Object> alAnnots, boolean bForceStacking, boolean bWriteMass) {
        double dScaleX = 1.0;
        double dScaleY = 1.0;
        double[] vals = this.htItemsToBestInt.get(dPeakMass);
        AnnotationGrid.AnnotationCell cellDP = this.grid.getNewCell(vals[0], vals[1]);
        if (cellDP == null) {
            return true;
        }
        int iLineDPX = (int)((double)cellDP.getScreenLowX() * dScaleX);
        int iLineDPY = (int)((double)cellDP.getScreenLowY() * dScaleY);
        int iLineMinX = Integer.MAX_VALUE;
        int iLineMaxX = Integer.MIN_VALUE;
        int iLineMaxY = Integer.MIN_VALUE;
        this.htAnnotationToCoords = new HashMap();
        int iPrefX = -1;
        for (Object oPeakAnnotation : alAnnots) {
            AnnotationGrid.AnnotationCell cell;
            if (vals[0] > 785.4 && vals[0] < 785.6 || vals[0] > 763.0 && vals[0] < 763.1 || vals[0] > 774.4 && vals[0] < 774.6) {
                System.out.println("Mass: " + vals[0]);
            }
            if ((cell = this.grid.putAnnotation(oPeakAnnotation, vals[0], vals[1], iPrefX)) == null && iPrefX != -1) {
                cell = this.grid.putAnnotation(oPeakAnnotation, vals[0], vals[1], -1);
            }
            if (cell == null) continue;
            if (vals[0] > 785.4 && vals[0] < 785.6 || vals[0] > 763.0 && vals[0] < 763.1 || vals[0] > 774.4 && vals[0] < 774.6) {
                System.out.println("\t Cell: " + cell);
            }
            int iCellX = (int)((double)cell.getScreenLowX() * dScaleX);
            int iCellX2 = (int)((double)cell.getScreenLowX() * dScaleX);
            int iCellY = (int)((double)cell.getScreenLowY() * dScaleY);
            int iCellY2 = (int)((double)cell.getScreenLowY() * dScaleY);
            if (bForceStacking && iPrefX != -1 && iPrefX != (int)cell.getScreenLowX()) {
                return false;
            }
            if (oPeakAnnotation instanceof GlycanImageProvider.GlycanImageObject) {
                GlycanImageProvider.GlycanImageObject gio = (GlycanImageProvider.GlycanImageObject)oPeakAnnotation;
                gio.dispose();
                double dScaleValX = this.grid.getCellWidth();
                double dScaleValY = this.grid.getCellHeight();
                BufferedImage bImg = gio.getAwtBufferedImage();
                int iW = bImg.getWidth();
                int iH = bImg.getHeight();
                double dScaleFromX = dScaleValX / (double)iW;
                double dScaleFromY = dScaleValY / (double)iH;
                int width = (int)((double)bImg.getWidth() * dScaleFromX);
                int height = (int)((double)bImg.getHeight() * dScaleFromY);
                Image newImage = bImg.getScaledInstance(width, height, 1);
                BufferedImage bScaledImg = SimianImageConverter.convert((Image)newImage);
                newImage.flush();
                double dW = bScaledImg.getWidth();
                double dH = bScaledImg.getHeight();
                double dScreenW = dW / this.getChartScale();
                double dScreen = dH;
                g2.drawImage(bScaledImg, iCellX, iCellY, (int)dScreenW, (int)dScreen, null);
                iCellY2 += bScaledImg.getHeight();
                iCellX2 += bScaledImg.getWidth();
            }
            if (iCellX2 > iLineMaxX) {
                iLineMaxX = iCellX2;
            }
            if (iCellX < iLineMinX) {
                iLineMinX = iCellX;
            }
            if (iCellY2 > iLineMaxY) {
                iLineMaxY = iCellY2;
            }
            iPrefX = (int)cell.getScreenLowX();
        }
        g2.setStroke(dashed);
        int iMidX = iLineMinX + (iLineMaxX - iLineMinX) / 2;
        Line2D.Float line1 = new Line2D.Float(iLineDPX, iLineDPY, iMidX, iLineMaxY);
        g2.setColor(Color.black);
        g2.draw(line1);
        if (bWriteMass) {
            int iTextWidth = g2.getFontMetrics().stringWidth(dPeakMass.toString());
            g2.drawString(dPeakMass.toString(), iMidX - iTextWidth / 2, iLineMaxY);
        }
        return true;
    }

    public void zoom(double percent) {
        super.zoom(percent);
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        super.draw(g2, area, anchor, parentState, info);
    }

    private class LabelGenerator
    extends AbstractXYItemLabelGenerator
    implements XYItemLabelGenerator {
        int iSeriesInx;
        private static final long serialVersionUID = 1L;

        public LabelGenerator(int iSeriesInx) {
            this.iSeriesInx = iSeriesInx;
        }

        public String generateLabel(XYDataset dataset, int x, int y) {
            dataset.getYValue(x, y);
            return GRITSXYPlot.this.getPeakLabel(this.iSeriesInx, dataset.getXValue(x, y)).toString();
        }
    }
}

