/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Fragmenter;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.grits.toolbox.ms.annotation.gelato.FragmentMatcher;
import org.grits.toolbox.ms.annotation.gelato.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Fragment;
import org.grits.toolbox.ms.om.data.FragmentPerActivationMethod;
import org.grits.toolbox.ms.om.data.FragmentPerMsLevel;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.GlycanScansAnnotation;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.Molecule;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;

public class AnnotateFragments {
    private static final Logger logger = Logger.getLogger(AnnotateFragments.class);
    protected GlycanScansAnnotation parentScansAnnotation = null;
    List<List<IonSettings>> lFragmentAdductsToAnalyze = new ArrayList<List<IonSettings>>();
    List<List<Integer>> lFragmentAdductCounts = new ArrayList<List<Integer>>();
    List<List<IonSettings>> lFragmentExchangesToAnalyze = new ArrayList<List<IonSettings>>();
    List<List<Integer>> lFragmentExchangesCounts = new ArrayList<List<Integer>>();
    List<List<MoleculeSettings>> lFragmentNeutralLossesToAnalyze = new ArrayList<List<MoleculeSettings>>();
    List<List<Integer>> lFragmentNeutralLossCounts = new ArrayList<List<Integer>>();

    public AnnotateFragments(GlycanScansAnnotation parentScansAnnotation) {
        this.parentScansAnnotation = parentScansAnnotation;
    }

    public static void determineIonSettingSets(Object lParentSettingsToConsider, List<Integer> lParentSettingsCounts, int iMaxTotalCount, Object lSettingsToAnalyze, List<List<Integer>> lSettingsToAnalyzeCounts) {
        try {
            if (lParentSettingsToConsider == null || ((List)lParentSettingsToConsider).isEmpty()) {
                return;
            }
            boolean bDone = false;
            int iStartLevel = 0;
            int[] iCurChargeCnts = new int[((List)lParentSettingsToConsider).size()];
            ArrayList<String> sProcessed = new ArrayList<String>();
            while (!bDone) {
                ArrayList<Molecule> lCurSet = new ArrayList<Molecule>();
                ArrayList<Integer> lCurCounts = new ArrayList<Integer>();
                int iTotalCharge = 0;
                int iLevelCnt = 0;
                String sCombo = "";
                for (iLevelCnt = 0; iLevelCnt <= iStartLevel; ++iLevelCnt) {
                    Molecule curSetting = (Molecule)((List)lParentSettingsToConsider).get(iLevelCnt);
                    int iCurCount = iCurChargeCnts[iLevelCnt] + 1;
                    if (curSetting instanceof IonSettings) {
                        iCurCount *= ((IonSettings)curSetting).getCharge().intValue();
                    }
                    if (iTotalCharge + iCurCount > iMaxTotalCount) continue;
                    iTotalCharge += iCurCount;
                    sCombo = sCombo + "[" + iLevelCnt + ", " + iCurCount + "+]";
                    lCurSet.add(curSetting);
                    lCurCounts.add(iCurChargeCnts[iLevelCnt] + 1);
                }
                if (iTotalCharge <= iMaxTotalCount && !sProcessed.contains(sCombo)) {
                    ((List)lSettingsToAnalyze).add(lCurSet);
                    lSettingsToAnalyzeCounts.add(lCurCounts);
                    sProcessed.add(sCombo);
                }
                if (++iStartLevel == iCurChargeCnts.length) {
                    for (int j = iCurChargeCnts.length - 1; j >= 0 && iStartLevel == iCurChargeCnts.length; --j) {
                        int iCurCnt = iCurChargeCnts[j] + 1;
                        int iMaxCnt = lParentSettingsCounts.get(j);
                        if (iCurCnt < iMaxCnt) {
                            int n = j;
                            iCurChargeCnts[n] = iCurChargeCnts[n] + 1;
                            iStartLevel = j;
                            continue;
                        }
                        iCurChargeCnts[j] = 0;
                    }
                }
                bDone = iStartLevel == iCurChargeCnts.length;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in determineIonSettingSets", (Throwable)e);
        }
    }

    protected void initializeAdductsAndExchanges(List<IonSettings> lParentAdducts, List<Integer> lParentAdductCounts, int iParentCharge, List<IonSettings> lParentIonExchanges, List<Integer> lParentExchangeCounts, int iParentExchangeCount, List<MoleculeSettings> lParentNeutralLosses, List<Integer> lParentNeutralLossCounts, int iParentNeutralLossCount) {
        this.lFragmentAdductsToAnalyze.clear();
        this.lFragmentAdductCounts.clear();
        this.lFragmentExchangesToAnalyze.clear();
        this.lFragmentExchangesCounts.clear();
        this.lFragmentNeutralLossesToAnalyze.clear();
        this.lFragmentNeutralLossCounts.clear();
        AnnotateFragments.determineIonSettingSets(lParentAdducts, lParentAdductCounts, iParentCharge, this.lFragmentAdductsToAnalyze, this.lFragmentAdductCounts);
        AnnotateFragments.determineIonSettingSets(lParentIonExchanges, lParentExchangeCounts, iParentExchangeCount, this.lFragmentExchangesToAnalyze, this.lFragmentExchangesCounts);
        AnnotateFragments.determineIonSettingSets(lParentNeutralLosses, lParentNeutralLossCounts, iParentNeutralLossCount, this.lFragmentNeutralLossesToAnalyze, this.lFragmentNeutralLossCounts);
    }

    public void annotateFragments(List<GlycanScansAnnotation> subScanAnnotation, int scanIndex, GlycanFeature parentFeature, GlycanStructure parentStructure, List<IonSettings> lParentAdducts, List<Integer> lParentAdductCounts, int iParentCharge, List<IonSettings> lParentIonExchanges, List<Integer> lParentExchangeCounts, int iParentExchangeCount, List<MoleculeSettings> lParentNeutralLosses, List<Integer> lParentNeutralLossCounts, int iParentNeutralLossCount, GlycanAnnotation annotation, String sequence, Data data, AnalyteSettings settings, int precursorIndex, String tempPath, AnnotationWriter writer) {
        List<FragmentEntry> fragments = this.getFragments(settings, scanIndex, sequence, data);
        if (fragments == null) {
            return;
        }
        this.initializeAdductsAndExchanges(lParentAdducts, lParentAdductCounts, iParentCharge, lParentIonExchanges, lParentExchangeCounts, iParentExchangeCount, lParentNeutralLosses, lParentNeutralLossCounts, iParentNeutralLossCount);
        int iCnt = 0;
        int iNumAdducts = this.lFragmentAdductsToAnalyze.size();
        int iNumExchanges = this.lFragmentExchangesToAnalyze != null ? this.lFragmentExchangesToAnalyze.size() : 0;
        int iNumLosses = this.lFragmentNeutralLossesToAnalyze != null ? this.lFragmentNeutralLossesToAnalyze.size() : 0;
        boolean iFragCnt = true;
        for (FragmentEntry fragment : fragments) {
            Glycan fragGlycan = Glycan.fromString((String)fragment.getStructure());
            GlycanAnnotation fragAnnotation = new GlycanAnnotation();
            fragAnnotation.setStringId(annotation.getStringId() + "-" + GlycanStructureAnnotation.iAnnotationIDCount);
            fragAnnotation.setSequenceGWB(fragment.getStructure());
            fragAnnotation.setId(Integer.valueOf(GlycanStructureAnnotation.iAnnotationIDCount));
            GlycanScansAnnotation fragScansAnnotation = new GlycanScansAnnotation();
            fragScansAnnotation.setAnnotationId(Integer.valueOf(GlycanStructureAnnotation.iAnnotationIDCount));
            fragScansAnnotation.setGlycanId(fragAnnotation.getStringId());
            GlycanStructure fragStructure = new GlycanStructure();
            fragStructure.setGWBSequence(fragment.getStructure());
            fragStructure.setId(fragAnnotation.getStringId());
            FragmentMatcher matcher = new FragmentMatcher(this.parentScansAnnotation);
            for (int i = 0; i < iNumAdducts; ++i) {
                for (int j = -1; j < iNumExchanges; ++j) {
                    for (int k = -1; k < iNumLosses; ++k) {
                        List<IonSettings> lAdducts = null;
                        List<Integer> lAdductCounts = null;
                        if (this.lFragmentAdductsToAnalyze == null || this.lFragmentAdductsToAnalyze.isEmpty() || this.lFragmentAdductCounts == null || this.lFragmentAdductCounts.isEmpty()) continue;
                        lAdducts = this.lFragmentAdductsToAnalyze.get(i);
                        lAdductCounts = this.lFragmentAdductCounts.get(i);
                        List<IonSettings> lExchanges = null;
                        List<Integer> lExchangeCounts = null;
                        if (j > -1) {
                            lExchanges = this.lFragmentExchangesToAnalyze.get(j);
                            lExchangeCounts = this.lFragmentExchangesCounts.get(j);
                        }
                        List<MoleculeSettings> lNeutralLosses = null;
                        List<Integer> lNeutralLossCounts = null;
                        if (k > -1) {
                            lNeutralLosses = this.lFragmentNeutralLossesToAnalyze.get(k);
                            lNeutralLossCounts = this.lFragmentNeutralLossCounts.get(k);
                        }
                        boolean bRes = matcher.matchFragment(fragScansAnnotation, scanIndex, fragAnnotation, fragGlycan, fragStructure, fragment.getStructure(), data, lAdducts, lAdductCounts, lExchanges, lExchangeCounts, lNeutralLosses, lNeutralLossCounts, settings, precursorIndex, fragment.name, tempPath, writer);
                        ++iCnt;
                    }
                }
            }
            if (fragScansAnnotation.getScanAnnotations().keySet().isEmpty()) continue;
            try {
                if (!subScanAnnotation.contains(fragScansAnnotation)) {
                    subScanAnnotation.add(fragScansAnnotation);
                }
                ++GlycanStructureAnnotation.iAnnotationIDCount;
                writer.writeAnnotationsPerGlycan(fragScansAnnotation, tempPath);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        logger.debug((Object)("Done with fragments. Total options considered: " + iCnt));
    }

    private List<FragmentEntry> getFragments(AnalyteSettings settings, int scanIndex, String sequence, Data data) {
        List<FragmentEntry> fragments = null;
        boolean match = false;
        AnnotateFragments ann = new AnnotateFragments(this.parentScansAnnotation);
        if (settings.getGlycanSettings().getPerActivation().size() != 0) {
            Scan scan = (Scan)data.getScans().get(scanIndex);
            for (FragmentPerActivationMethod f : settings.getGlycanSettings().getPerActivation()) {
                if (!f.getActivationMethod().equals(scan.getActivationMethode().trim())) continue;
                fragments = ann.generateFragments(sequence, data, settings, f.getFragments(), f.getMaxNumOfCleavages(), f.getMaxNumOfCrossRingCleavages());
                match = true;
                break;
            }
            if (!match) {
                fragments = ann.generateFragments(sequence, data, settings, settings.getGlycanSettings().getGlycanFragments(), settings.getGlycanSettings().getMaxNumOfCleavages(), settings.getGlycanSettings().getMaxNumOfCrossRingCleavages());
            }
        } else if (settings.getGlycanSettings().getPerMsLevel().size() != 0) {
            Scan scan = (Scan)data.getScans().get(scanIndex);
            for (FragmentPerMsLevel f : settings.getGlycanSettings().getPerMsLevel()) {
                if (f.getMsLevel() != scan.getMsLevel()) continue;
                fragments = ann.generateFragments(sequence, data, settings, f.getFragments(), f.getM_maxNumOfCleavages(), f.getM_maxNumOfCrossRingCleavages());
                match = true;
                break;
            }
            if (!match) {
                fragments = ann.generateFragments(sequence, data, settings, settings.getGlycanSettings().getGlycanFragments(), settings.getGlycanSettings().getMaxNumOfCleavages(), settings.getGlycanSettings().getMaxNumOfCrossRingCleavages());
            }
        } else {
            fragments = ann.generateFragments(sequence, data, settings, settings.getGlycanSettings().getGlycanFragments(), settings.getGlycanSettings().getMaxNumOfCleavages(), settings.getGlycanSettings().getMaxNumOfCrossRingCleavages());
        }
        return fragments;
    }

    private List<FragmentEntry> generateFragments(String sequence, Data data, AnalyteSettings settings, List<Fragment> fragments, int maxNumClvg, int maxNumCr) {
        BuilderWorkspace bw = new BuilderWorkspace((GlycanRenderer)new GlycanRendererAWT());
        Fragmenter t_fragmenter = new Fragmenter();
        t_fragmenter.setComputeBFragments(false);
        t_fragmenter.setComputeYFragments(false);
        t_fragmenter.setComputeCFragments(false);
        t_fragmenter.setComputeZFragments(false);
        t_fragmenter.setComputeAFragments(false);
        t_fragmenter.setComputeXFragments(false);
        for (Fragment fragment : fragments) {
            if (fragment.getType().equals("B")) {
                t_fragmenter.setComputeBFragments(true);
            }
            if (fragment.getType().equals("Y")) {
                t_fragmenter.setComputeYFragments(true);
            }
            if (fragment.getType().equals("C")) {
                t_fragmenter.setComputeCFragments(true);
            }
            if (fragment.getType().equals("Z")) {
                t_fragmenter.setComputeZFragments(true);
            }
            if (fragment.getType().equals("A")) {
                t_fragmenter.setComputeAFragments(true);
            }
            if (!fragment.getType().equals("X")) continue;
            t_fragmenter.setComputeXFragments(true);
        }
        t_fragmenter.setMaxNoCleavages(maxNumClvg);
        t_fragmenter.setMaxNoCrossRings(maxNumCr);
        try {
            Glycan t_glycan = Glycan.fromString((String)sequence);
            t_glycan.setMassOptions(this.collectMassOptions(settings, data));
            FragmentCollection fc = t_fragmenter.computeAllFragments(t_glycan);
            return (List)fc.getFragments();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private MassOptions collectMassOptions(AnalyteSettings settings, Data data) {
        MassOptions t_massOptions = new MassOptions();
        if (settings.getGlycanSettings().getPerDerivatisationType().equals("perMe")) {
            t_massOptions.setDerivatization("perMe");
        } else if (settings.getGlycanSettings().getPerDerivatisationType().equals("perMe(C^13)")) {
            t_massOptions.setDerivatization("perMe(C^13)");
        } else if (settings.getGlycanSettings().getPerDerivatisationType().equals("perDMe")) {
            t_massOptions.setDerivatization("perDMe");
        } else if (settings.getGlycanSettings().getPerDerivatisationType().equals("perAc")) {
            t_massOptions.setDerivatization("perAc");
        } else if (settings.getGlycanSettings().getPerDerivatisationType().equals("perDAc")) {
            t_massOptions.setDerivatization("perDAc");
        } else {
            t_massOptions.setDerivatization("Und");
        }
        if (data.getDataHeader().getMethod().getMonoisotopic().booleanValue()) {
            t_massOptions.setIsotope("MONO");
        } else {
            t_massOptions.setIsotope("AVG");
        }
        t_massOptions.setReducingEndType(ResidueDictionary.findResidueType((String)settings.getGlycanSettings().getReducingEnd().getType()));
        return t_massOptions;
    }

    private double calculateZ(int count, IonSettings adduct) {
        return (double)adduct.getCharge().intValue() * (double)count;
    }

    private double addIonExchange(IonSettings ionExchange, int count) {
        return ionExchange.getMass() * (double)count - (double)count;
    }

    private double addNutralLoss(MoleculeSettings nutralLoss, int count, double mass) {
        return nutralLoss.getMass() * (double)count;
    }

    private double calculateFragmentMz(double mass, double z, double glycanMz, IonSettings adduct) {
        if (z == 0.0) {
            z = 1.0;
        }
        return mass / z + adduct.getMass();
    }
}

