/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.property.io;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedTypeException;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.jdom.Element;

public class MassSpecReaderVersion0 {
    private static final Logger logger = Logger.getLogger(MassSpecReaderVersion0.class);

    public static Property read(Element propertyElement, MassSpecProperty msProperty) throws IOException, UnsupportedVersionException, UnsupportedTypeException {
        String t_attributeValue = null;
        Element entryElement = propertyElement.getDocument().getRootElement().getChild("entry");
        String projectName = entryElement == null ? null : entryElement.getAttributeValue("name");
        String workspaceFolder = PropertyHandler.getVariable((String)"workspace_location");
        String msFolder = String.valueOf(workspaceFolder.substring(0, workspaceFolder.length() - 1)) + File.separator + projectName + File.separator + MassSpecProperty.getFoldername();
        Entry msEntry = new Entry();
        MassSpecMetaData model = new MassSpecMetaData();
        msProperty.setMassSpecMetaData(model);
        msEntry.setProperty((Property)msProperty);
        Element child = propertyElement.getChild("settings");
        if (child != null) {
            t_attributeValue = child.getAttributeValue("derivatisation");
            model.setDerivatizationName(t_attributeValue);
            t_attributeValue = child.getAttributeValue("instrument");
            model.setInstrument(t_attributeValue);
            t_attributeValue = child.getAttributeValue("experimentType");
            model.setMsExperimentType(t_attributeValue);
            t_attributeValue = child.getAttributeValue("collusionTypeName");
            model.setCollisionTypeName(t_attributeValue);
            t_attributeValue = child.getAttributeValue("collusionEnergy");
            model.setCollisionEnergy(Double.parseDouble(t_attributeValue));
            t_attributeValue = child.getAttributeValue("adductName");
            model.setAdductName(t_attributeValue);
            t_attributeValue = child.getAttributeValue("glycanType");
            model.setGlycanType(t_attributeValue);
        }
        if (model.getMsExperimentType() == null || model.getMsExperimentType().equals("")) {
            throw new UnsupportedVersionException("Expecting the 'settings' element and 'experimentType' attribute in the project file.", "Preversion");
        }
        String origRawFile = null;
        child = propertyElement.getChild("spectra_msn");
        if (child != null) {
            t_attributeValue = child.getAttributeValue("raw");
            if (t_attributeValue != null) {
                origRawFile = t_attributeValue;
                MSPropertyDataFile rawFile = MassSpecUISettings.getLegacyVersionRawPropertyDataFile(t_attributeValue, t_attributeValue, false);
                msProperty.getDataFiles().add(rawFile);
            }
            if ((t_attributeValue = child.getAttributeValue("mzXML")) != null) {
                MSPropertyDataFile mzFile = MassSpecUISettings.getLegacyVersionMzPropertyDataFile(t_attributeValue, t_attributeValue, false);
                msProperty.getDataFiles().add(mzFile);
            }
        }
        if (origRawFile == null) {
            throw new UnsupportedVersionException("Expecting the 'spectra_msn' element and 'raw' attribute in the project file.", "Preversion");
        }
        Pattern p = Pattern.compile("^(\\d{4}\\.\\d{2}\\.\\d{2}\\-\\d{2}\\.\\d{2}\\.\\d{2}\\.\\d{4})\\.");
        Matcher m = p.matcher(origRawFile);
        String datePrefix = null;
        if (m.find()) {
            datePrefix = m.group(1);
        } else {
            SimpleDateFormat formater = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss.SSSS");
            Date date = new Date();
            datePrefix = formater.format(date);
        }
        String msDetails = String.valueOf(datePrefix) + "." + "msMetaData.xml";
        MassSpecProperty.marshallSettingsFile(String.valueOf(msFolder) + File.separator + msDetails, model);
        model.setVersion("1.2");
        PropertyDataFile msMetaData = MassSpecMetaData.getNewSettingsFile(msDetails, model);
        msProperty.getDataFiles().add(msMetaData);
        child = propertyElement.getChild("spectra_full");
        if (child != null) {
            t_attributeValue = child.getAttributeValue("raw");
            if (t_attributeValue != null) {
                MSPropertyDataFile rawFile = MassSpecUISettings.getLegacyVersionRawPropertyDataFile(t_attributeValue, t_attributeValue, true);
                msProperty.getDataFiles().add(rawFile);
            }
            if ((t_attributeValue = child.getAttributeValue("mzXML")) != null) {
                MSPropertyDataFile mzFile = MassSpecUISettings.getLegacyVersionMzPropertyDataFile(t_attributeValue, t_attributeValue, true);
                msProperty.getDataFiles().add(mzFile);
            }
        }
        if ((child = propertyElement.getChild("peakListInfo")) != null) {
            MSPropertyDataFile peakListFile;
            String origPeakListFile = null;
            String origPeakListFormat = null;
            t_attributeValue = child.getAttributeValue("peakListFileName");
            if (t_attributeValue != null) {
                origPeakListFile = String.valueOf(msFolder) + File.separator + t_attributeValue;
            }
            if ((t_attributeValue = child.getAttributeValue("peakListFileFormat")) != null) {
                origPeakListFormat = String.valueOf(msFolder) + File.separator + t_attributeValue;
            }
            if ((peakListFile = MassSpecUISettings.getLegacyVersionPeakListPropertyDataFile(origPeakListFile, origPeakListFile, origPeakListFormat)) != null) {
                msProperty.getDataFiles().add(peakListFile);
            }
        }
        return msProperty;
    }
}

