/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.property.datamodel;

import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;

@XmlRootElement(name="msMetaData")
public class MassSpecMetaData
extends MassSpecUISettings {
    public static final String CURRENT_VERSION = "1.2";
    private String name = null;
    private String version = null;
    private String description = null;
    private String msExperimentType = null;
    private String derivatizationName = null;
    private String instrument = null;
    private String collisionTypeName = null;
    private Double collisionEnergy = null;
    private String adductName = null;
    private String releaseType = null;
    private String glycanType = null;
    private Date creationDate = null;
    private Date updateDate = null;

    public static String getCurrentVersion() {
        return CURRENT_VERSION;
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="description", required=false)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute(name="version", required=true)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlAttribute(name="msExperimentType", required=true)
    public void setMsExperimentType(String msExperimentType) {
        this.msExperimentType = msExperimentType;
    }

    public String getMsExperimentType() {
        return this.msExperimentType;
    }

    @XmlAttribute(name="derivatizationName", required=false)
    public String getDerivatizationName() {
        return this.derivatizationName;
    }

    public void setDerivatizationName(String derivatizationName) {
        this.derivatizationName = derivatizationName;
    }

    @XmlAttribute(name="instrument", required=false)
    public String getInstrument() {
        return this.instrument;
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }

    @XmlAttribute(name="collisionTypeName", required=false)
    public String getCollisionTypeName() {
        return this.collisionTypeName;
    }

    public void setCollisionTypeName(String collisionTypeName) {
        this.collisionTypeName = collisionTypeName;
    }

    @XmlAttribute(name="collisionEnergy", required=false)
    public Double getCollisionEnergy() {
        return this.collisionEnergy;
    }

    public void setCollisionEnergy(Double collisionEnergy) {
        this.collisionEnergy = collisionEnergy;
    }

    @XmlAttribute(name="adductName", required=false)
    public String getAdductName() {
        return this.adductName;
    }

    public void setAdductName(String adductName) {
        this.adductName = adductName;
    }

    @XmlAttribute(name="releaseType", required=false)
    public String getReleaseType() {
        return this.releaseType;
    }

    public void setReleaseType(String releaseType) {
        this.releaseType = releaseType;
    }

    @XmlAttribute(name="glycanType", required=false)
    public String getGlycanType() {
        return this.glycanType;
    }

    public void setGlycanType(String glycanType) {
        this.glycanType = glycanType;
    }

    @XmlAttribute
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @XmlAttribute
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public static PropertyDataFile getNewSettingsFile(String msDetails, MassSpecMetaData metaData) {
        PropertyDataFile msPropertyDataFile = new PropertyDataFile(msDetails, CURRENT_VERSION, "details");
        return msPropertyDataFile;
    }

    public Object clone() {
        MassSpecMetaData newSettings = new MassSpecMetaData();
        this.cloneSettings(newSettings);
        return newSettings;
    }

    @Override
    public void cloneSettings(MassSpecUISettings settings) {
        MassSpecMetaData newSettings = (MassSpecMetaData)settings;
        newSettings.setAdductName(this.adductName);
        newSettings.setCollisionEnergy(this.collisionEnergy);
        newSettings.setCollisionTypeName(this.collisionTypeName);
        newSettings.setDerivatizationName(this.derivatizationName);
        newSettings.setGlycanType(this.glycanType);
        newSettings.setInstrument(this.instrument);
        newSettings.setMsExperimentType(this.msExperimentType);
        newSettings.setReleaseType(this.releaseType);
        newSettings.setUpdateDate(this.updateDate);
        newSettings.setCreationDate(this.creationDate);
        super.cloneSettings(settings);
    }
}

