/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.property;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.grits.toolbox.entry.ms.property.FileLockManager;

public class FileLockingUtils {
    public static final String LOCK_FILE = ".lockFile";

    public static FileLockManager readLockFile(String filePath) throws IOException, JAXBException {
        File lockFile = new File(filePath);
        FileLockManager mng = null;
        if (!lockFile.exists()) {
            mng = new FileLockManager();
            FileLockingUtils.writeLockFile(mng, filePath);
        } else {
            FileInputStream inputStream = new FileInputStream(filePath);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{FileLockManager.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            mng = (FileLockManager)unmarshaller.unmarshal((Reader)reader);
        }
        return mng;
    }

    public static void writeLockFile(FileLockManager mng, String filePath) throws JAXBException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{FileLockManager.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)mng, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(filePath);
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
    }
}

