/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.filter;

import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;
import org.grits.toolbox.ms.om.data.IntensityFilter;
import org.grits.toolbox.ms.om.data.MSFilterVisitor;
import org.grits.toolbox.util.structure.glycan.filter.GlycanFilterException;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterVisitor;

public class MSGlycanAnnotationFilterVisitor
extends GlycanFilterVisitor
implements MSFilterVisitor {
    MSAnnotationTable table;
    Integer rowNumber;

    public boolean evaluate(MSAnnotationTable table, Integer index, Sugar sugar) throws GlycanFilterException {
        this.m_sugar = sugar;
        this.table = table;
        this.rowNumber = index;
        if (this.m_filter == null) {
            throw new GlycanFilterException("No filter is set");
        }
        return this.m_filter.accept((GlycanFilterVisitor)this);
    }

    public boolean visit(IntensityFilter intensityFilter) throws GlycanFilterException {
        if (this.table == null || this.rowNumber == null) {
            throw new GlycanFilterException("No data provided");
        }
        int columnIndex = this.table.getColumnIndexForKey(intensityFilter.getIntensityColumnKey());
        if (columnIndex == -1) {
            columnIndex = this.table.getColumnIndexForKeyByContains(intensityFilter.getIntensityColumnKey());
        }
        if (columnIndex == -1) {
            throw new GlycanFilterException("Column " + intensityFilter.getIntensityColumnKey() + " does not exist in the table");
        }
        Double intensityValue = (Double)this.table.getBottomDataLayer().getDataValueByPosition(columnIndex, this.rowNumber.intValue());
        if (intensityFilter.getMin() != null && (double)intensityFilter.getMin().intValue() > intensityValue) {
            return false;
        }
        return intensityFilter.getMax() == null || !((double)intensityFilter.getMax().intValue() < intensityValue);
    }

    public MSAnnotationTable getTable() {
        return this.table;
    }

    public void setTable(MSAnnotationTable table) {
        this.table = table;
    }

    public Integer getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(Integer rowNumber) {
        this.rowNumber = rowNumber;
    }
}

