/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.preference.doctype;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.grits.toolbox.entry.archive.model.DocumentType;

public class DocumentTypeFontLabelProvider
implements ITableLabelProvider,
ITableFontProvider {
    public static final String DEFAULT_STRING = " (default)";
    private TreeViewer treeViewer = null;
    private Font boldFont = null;

    public DocumentTypeFontLabelProvider(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        Font currentFont = Display.getCurrent().getSystemFont();
        FontData fontData = currentFont.getFontData()[0];
        this.boldFont = new Font((Device)Display.getCurrent(), fontData.getName(), fontData.getHeight(), 1);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Font getFont(Object element, int columnIndex) {
        if (element instanceof DocumentType && columnIndex == 0) {
            return ((DocumentType)element).isMakeDefault() ? this.boldFont : null;
        }
        if (element instanceof String && columnIndex == 1) {
            Font font = null;
            TreeItem[] treeItemArray = this.treeViewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() instanceof DocumentType && ((DocumentType)item.getData()).getSelectedSubType() == element) {
                    font = this.boldFont;
                    break;
                }
                ++n2;
            }
            return font;
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof DocumentType && columnIndex == 0) {
            DocumentType documentType = (DocumentType)element;
            return documentType.isMakeDefault() ? String.valueOf(documentType.getLabel()) + DEFAULT_STRING : documentType.getLabel();
        }
        if (element instanceof String && columnIndex == 1) {
            String suffix = "";
            TreeItem[] treeItemArray = this.treeViewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() instanceof DocumentType && ((DocumentType)item.getData()).getSelectedSubType() == element) {
                    suffix = DEFAULT_STRING;
                    break;
                }
                ++n2;
            }
            return element + suffix;
        }
        return null;
    }
}

