/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.EntityWithPosition;

@XmlRootElement(name="descriptorGroup")
@XmlType(propOrder={"label", "uri", "maxOccurrence", "description", "categories", "mandatoryDescriptors", "optionalDescriptors"})
public class DescriptorGroup
implements EntityWithPosition {
    private String uri = null;
    private String label = null;
    private String description = null;
    private Integer maxOccurrence = null;
    private List<String> categories = new ArrayList<String>();
    private List<Descriptor> mandatoryDescriptors = new ArrayList<Descriptor>();
    private List<Descriptor> optionalDescriptors = new ArrayList<Descriptor>();
    private Integer position = null;

    @XmlAttribute(name="uri", required=true)
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @XmlAttribute(name="label", required=true)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @XmlElement(name="description", required=true)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute(name="maxOccurrence", required=true)
    public Integer getMaxOccurrence() {
        return this.maxOccurrence;
    }

    public void setMaxOccurrence(Integer maxOccurrence) {
        this.maxOccurrence = maxOccurrence;
    }

    @XmlElement(name="category")
    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    @XmlElement(name="mandatoryDescriptor", required=false)
    public List<Descriptor> getMandatoryDescriptors() {
        return this.mandatoryDescriptors;
    }

    public void setMandatoryDescriptors(List<Descriptor> mandatoryDescriptors) {
        this.mandatoryDescriptors = mandatoryDescriptors;
    }

    public void addMandatoryDescriptor(Descriptor mandatoryDescriptor) {
        this.mandatoryDescriptors.add(mandatoryDescriptor);
    }

    @XmlElement(name="optionalDescriptor", required=false)
    public List<Descriptor> getOptionalDescriptors() {
        return this.optionalDescriptors;
    }

    public void setOptionalDescriptors(List<Descriptor> optionalDescriptors) {
        this.optionalDescriptors = optionalDescriptors;
    }

    public void addOptionalDescriptor(Descriptor optionalDescriptor) {
        this.optionalDescriptors.add(optionalDescriptor);
    }

    public void setColumnValue(String string) {
        this.setLabel(string);
    }

    @Override
    @XmlAttribute
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Integer position) {
        this.position = position;
    }

    public DescriptorGroup getACopy() {
        DescriptorGroup descriptorGroup = new DescriptorGroup();
        descriptorGroup.setLabel(this.getLabel());
        descriptorGroup.setUri(this.getUri());
        descriptorGroup.setDescription(this.getDescription());
        descriptorGroup.setCategories(new ArrayList<String>(this.getCategories()));
        descriptorGroup.setPosition(this.getPosition());
        if (this.maxOccurrence != null) {
            descriptorGroup.setMaxOccurrence((int)this.maxOccurrence);
        }
        for (Descriptor desc : this.mandatoryDescriptors) {
            descriptorGroup.addMandatoryDescriptor(desc.getACopy());
        }
        for (Descriptor desc : this.optionalDescriptors) {
            descriptorGroup.addOptionalDescriptor(desc.getACopy());
        }
        return descriptorGroup;
    }
}

