/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.dialog;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.dialog.contentprovider.DescriptorGroupTableContentProvider;
import org.grits.toolbox.entry.sample.dialog.labelprovider.DescriptorGroupTableLabelProvider;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.part.action.AddDescriptorAction;
import org.grits.toolbox.entry.sample.part.action.DeleteDescriptorDescriptorGroupAction;
import org.grits.toolbox.entry.sample.part.action.EditDescriptorDescriptorGroupAction;
import org.grits.toolbox.entry.sample.part.editsupport.EditingSupportForUnit;
import org.grits.toolbox.entry.sample.part.editsupport.EditingSupportForValue;
import org.grits.toolbox.entry.sample.utilities.ButtonWithAction;

public class AddDescriptorGroupDialog
extends TitleAreaDialog {
    @Inject
    private IEclipseContext eclipseContext = null;
    private DescriptorGroup descriptorGroup = null;
    private ComboViewer descriptorGroupCombo = null;
    private TableViewer descriptorsTable = null;
    private List<DescriptorGroup> availableDescriptorGroups = new ArrayList<DescriptorGroup>();
    private DescriptorGroupTableLabelProvider labelProvider = null;

    @Inject
    public AddDescriptorGroupDialog(Shell parentShell) {
        super(parentShell);
    }

    public void init(DescriptorGroup descriptorGroup) {
        this.descriptorGroup = descriptorGroup;
    }

    public void init(List<DescriptorGroup> availableDescriptorGroups) {
        this.availableDescriptorGroups = availableDescriptorGroups;
    }

    public void create() {
        super.create();
        String title = this.descriptorGroup == null ? "Adding a Decriptor Group" : "Edit the Descriptor Group";
        this.setTitle(title);
        this.setMessage("Please enter the following information");
        this.initializeValues();
    }

    private void initializeValues() {
        if (this.descriptorGroup == null) {
            this.descriptorGroupCombo.setInput(this.availableDescriptorGroups);
            this.getButton(0).setEnabled(false);
        } else {
            this.availableDescriptorGroups = new ArrayList<DescriptorGroup>();
            this.availableDescriptorGroups.add(this.descriptorGroup);
            this.descriptorGroupCombo.setInput(this.availableDescriptorGroups);
            this.descriptorGroupCombo.setSelection((ISelection)new StructuredSelection((Object)this.descriptorGroup));
        }
    }

    public Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(comp, 4);
        Image image = this.descriptorGroup == null ? ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.ADD_DESCRIPTOR_GROUP_ICON).createImage() : ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.EDIT_DESCRIPTOR_ICON).createImage();
        container.getShell().setImage(image);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 15;
        layout.marginBottom = 20;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 4);
        label.setText("Descriptor Group");
        GridData labelGridData = new GridData(1, 1, false, false, 1, 1);
        label.setLayoutData((Object)labelGridData);
        this.descriptorGroupCombo = new ComboViewer(container, 8);
        GridData comboLayoutData = new GridData(4, 1, true, false, 2, 1);
        this.descriptorGroupCombo.getCombo().setLayoutData((Object)comboLayoutData);
        this.descriptorGroupCombo.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.descriptorGroupCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element instanceof DescriptorGroup ? ((DescriptorGroup)element).getLabel() : null;
            }
        });
        this.descriptorsTable = new TableViewer(container, 68356);
        TableViewerColumn column1 = new TableViewerColumn(this.descriptorsTable, 16384);
        column1.getColumn().setText("Descriptor");
        column1.getColumn().setWidth(150);
        TableViewerColumn column2 = new TableViewerColumn(this.descriptorsTable, 16384);
        column2.getColumn().setText("Value");
        column2.setEditingSupport((EditingSupport)new EditingSupportForValue(this.descriptorsTable));
        column2.getColumn().setWidth(150);
        TableViewerColumn column3 = new TableViewerColumn(this.descriptorsTable, 16384);
        column3.getColumn().setText("Unit");
        column3.setEditingSupport((EditingSupport)new EditingSupportForUnit(this.descriptorsTable));
        column3.getColumn().setWidth(150);
        this.descriptorsTable.setContentProvider((IContentProvider)new DescriptorGroupTableContentProvider());
        this.labelProvider = new DescriptorGroupTableLabelProvider();
        this.descriptorsTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        GridData gridDataTable = new GridData(4, 1, true, false, 3, 1);
        gridDataTable.heightHint = 200;
        this.descriptorsTable.getTable().setLayoutData((Object)gridDataTable);
        this.descriptorsTable.getTable().setHeaderVisible(true);
        this.descriptorsTable.getTable().setLinesVisible(true);
        Composite buttonComposite = new Composite(container, 4);
        buttonComposite.setLayout((Layout)new GridLayout(3, false));
        buttonComposite.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
        Button addButton = this.createButton(buttonComposite, "Add");
        AddDescriptorAction addDescriptorAction = (AddDescriptorAction)((Object)ContextInjectionFactory.make(AddDescriptorAction.class, (IEclipseContext)this.eclipseContext));
        addDescriptorAction.init(this.descriptorsTable);
        addButton.addSelectionListener((SelectionListener)new ButtonWithAction((IAction)addDescriptorAction));
        Button editButton = this.createButton(buttonComposite, "Edit");
        final EditDescriptorDescriptorGroupAction editAction = (EditDescriptorDescriptorGroupAction)((Object)ContextInjectionFactory.make(EditDescriptorDescriptorGroupAction.class, (IEclipseContext)this.eclipseContext));
        editAction.init(this.descriptorsTable);
        editButton.addSelectionListener((SelectionListener)new ButtonWithAction((IAction)editAction));
        Button deleteButton = this.createButton(buttonComposite, "Delete");
        DeleteDescriptorDescriptorGroupAction deleteAction = (DeleteDescriptorDescriptorGroupAction)((Object)ContextInjectionFactory.make(DeleteDescriptorDescriptorGroupAction.class, (IEclipseContext)this.eclipseContext));
        deleteAction.init(this.descriptorsTable);
        deleteButton.addSelectionListener((SelectionListener)new ButtonWithAction((IAction)deleteAction));
        this.descriptorGroupCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!AddDescriptorGroupDialog.this.descriptorGroupCombo.getSelection().isEmpty()) {
                    AddDescriptorGroupDialog.this.getButton(0).setEnabled(true);
                    DescriptorGroup descriptorGroup = (DescriptorGroup)((StructuredSelection)AddDescriptorGroupDialog.this.descriptorGroupCombo.getSelection()).getFirstElement();
                    AddDescriptorGroupDialog.this.labelProvider.setDescriptorGroup(descriptorGroup);
                    AddDescriptorGroupDialog.this.descriptorsTable.setInput((Object)descriptorGroup);
                    AddDescriptorGroupDialog.this.descriptorsTable.refresh();
                }
            }
        });
        this.descriptorsTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                editAction.run();
            }
        });
        container.setLayoutData((Object)new GridData(1808));
        comp.setLayoutData((Object)new GridData(1808));
        return comp;
    }

    private Button createButton(Composite container, String name) {
        Button button = new Button(container, 8);
        button.setText(name);
        GridData buttonLayoutData = new GridData(1, 1, false, false, 1, 1);
        buttonLayoutData.widthHint = 100;
        buttonLayoutData.heightHint = 30;
        button.setLayoutData((Object)buttonLayoutData);
        return button;
    }

    public boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        if (!this.descriptorGroupCombo.getSelection().isEmpty()) {
            this.descriptorGroup = (DescriptorGroup)((StructuredSelection)this.descriptorGroupCombo.getSelection()).getFirstElement();
            super.okPressed();
        }
    }

    public DescriptorGroup getDescriptorGroup() {
        return this.descriptorGroup;
    }
}

