/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.MassSpecPreferenceLoader;
import org.grits.toolbox.entry.ms.property.FileLockManager;
import org.grits.toolbox.entry.ms.property.FileLockingUtils;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.importer.ms.handler.NewMSHandler;
import org.grits.toolbox.importer.ms.wizard.PageOne;
import org.grits.toolbox.ms.file.MSFile;

public class NewMSWizard
extends Wizard {
    private static final Logger logger = Logger.getLogger(NewMSWizard.class);
    protected PageOne one = null;
    private Entry sampleEntry = null;
    protected static MassSpecPreference preferences = null;
    boolean fileTypeCorrect = true;
    private Entry newMSEntry;
    private List<MSPropertyDataFile> allFiles = new ArrayList<MSPropertyDataFile>();

    public NewMSWizard() {
        this.setNeedsProgressMonitor(true);
        preferences = MassSpecPreferenceLoader.getMassSpecPreferences();
    }

    public void addPages() {
        this.one = new PageOne();
        if (this.sampleEntry != null) {
            this.one.setSampleEntry(this.sampleEntry);
        }
        this.addPage((IWizardPage)this.one);
        this.setForcePreviousAndNextButtons(true);
    }

    public void setSample(Entry entry) {
        this.sampleEntry = entry;
    }

    public boolean performFinish() {
        this.getOne().save();
        preferences.saveValues();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewMSWizard.this.fileTypeCorrect = NewMSWizard.this.doFinish(monitor, NewMSWizard.this.allFiles);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            logger.error((Object)realException.getMessage(), realException);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return this.fileTypeCorrect;
    }

    private boolean doFinish(IProgressMonitor monitor, List<MSPropertyDataFile> allFiles) throws CoreException {
        String sMsPath;
        block16: {
            monitor.beginTask("Finishing...", allFiles != null ? allFiles.size() + 2 : 2);
            monitor.subTask("Checking files for validity");
            boolean bPass = true;
            for (MSPropertyDataFile msPropertyDataFile : allFiles) {
                if (msPropertyDataFile.getMSFileType().equals("Converted") || msPropertyDataFile.getMSFileType().equals("Processed")) {
                    MSFile msFile = msPropertyDataFile.getMSFileWithReader("", this.getOne().getMsExperimentType());
                    if (msFile.getReader() != null) {
                        bPass = msFile.getReader().isValid(msFile);
                    }
                    if (!bPass) {
                        throw new CoreException((IStatus)new Status(4, "org.grits.toolbox.importer.ms", "The specified MS File (" + msPropertyDataFile.getName() + ") is not valid.\n\nPlease correct this and continue."));
                    }
                }
                if (msPropertyDataFile.getChildren() != null) {
                    for (MSPropertyDataFile child : msPropertyDataFile.getChildren()) {
                        if (!child.getMSFileType().equals("Converted") && !child.getMSFileType().equals("Processed")) continue;
                        MSFile msFile = child.getMSFileWithReader("", this.getOne().getMsExperimentType());
                        if (msFile.getReader() != null) {
                            bPass = msFile.getReader().isValid(msFile);
                        }
                        if (bPass) continue;
                        throw new CoreException((IStatus)new Status(4, "org.grits.toolbox.importer.ms", "The specified MS File (" + child.getName() + ") is not valid.\n\nPlease correct this and continue."));
                    }
                }
                monitor.worked(1);
            }
            sMsPath = NewMSHandler.createMassSpecPath(this.getShell(), this);
            if (sMsPath == null) {
                throw new Exception("Unable to create mass spec path.");
            }
            monitor.subTask("Creating entry");
            this.newMSEntry = this.createNewEntry(allFiles);
            monitor.worked(1);
            if (this.newMSEntry != null) break block16;
            return false;
        }
        try {
            monitor.subTask("Copying files into workspace");
            MassSpecProperty.copyMSFilesIntoWorkspace(allFiles, (String)sMsPath, (Entry)this.newMSEntry);
            monitor.subTask("Updating File Lock");
            try {
                String metadataPath = ((MassSpecProperty)this.newMSEntry.getProperty()).getMSSettingsFile().getName();
                String lockFileName = String.valueOf(sMsPath) + File.separator;
                lockFileName = metadataPath.lastIndexOf(File.separator) != -1 ? String.valueOf(lockFileName) + metadataPath.substring(0, metadataPath.lastIndexOf(File.separator)) + File.separator + ".lockFile" : String.valueOf(lockFileName) + ".lockFile";
                FileLockManager fileLockManager = FileLockingUtils.readLockFile((String)lockFileName);
                MassSpecMetaData metaData = ((MassSpecProperty)this.newMSEntry.getProperty()).getMassSpecMetaData();
                for (MSPropertyDataFile file : metaData.getFileList()) {
                    fileLockManager.addFile(file.getName());
                    if (file.getChildren() == null) continue;
                    for (MSPropertyDataFile child : file.getChildren()) {
                        fileLockManager.addFile(child.getName());
                    }
                }
                FileLockingUtils.writeLockFile((FileLockManager)fileLockManager, (String)lockFileName);
            }
            catch (Exception e) {
                logger.error((Object)"Error adding file to the .lockfile", (Throwable)e);
            }
            monitor.worked(1);
            monitor.done();
            return true;
        }
        catch (CoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Error in performFinish.", (Throwable)ex);
            return false;
        }
    }

    public PageOne getOne() {
        return this.one;
    }

    public Entry createNewEntry(List<MSPropertyDataFile> allFiles) {
        Entry entry = new Entry();
        entry.setDisplayName(this.one.getName());
        MassSpecProperty property = new MassSpecProperty();
        property.setVersion("1.3");
        MassSpecMetaData model = new MassSpecMetaData();
        property.setMassSpecMetaData(model);
        model.setVersion("1.2");
        model.setCreationDate(new Date());
        model.setUpdateDate(model.getCreationDate());
        property.getMassSpecMetaData().setDescription(this.one.getMSDescription());
        property.getMassSpecMetaData().setMsExperimentType(this.one.getMsExperimentType());
        property.getMassSpecMetaData().setInstrument(this.one.getSettingsPreference().getInstrument());
        property.getMassSpecMetaData().setFileList(allFiles);
        entry.setProperty((Property)property);
        return entry;
    }

    public Entry getEntry() {
        return this.newMSEntry;
    }

    public List<MSPropertyDataFile> getAllFiles() {
        return this.allFiles;
    }
}

