/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.io.ms.annotation.glycan.process.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.io.ms.annotation.listener.ExcelListener;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationWriterExcel;
import org.grits.toolbox.utils.image.GlycanImageProvider;
import org.grits.toolbox.utils.io.ExcelWriterHelper;

public class MSGlycanAnnotationWriterExcel
extends MSAnnotationWriterExcel {
    protected List<Picture> m_images = new ArrayList<Picture>();
    protected ExcelWriterHelper helper = new ExcelWriterHelper();
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationWriterExcel.class);

    public void createNewFile(String a_strFilename, MSAnnotationTableDataObject a_msAnnotationDataObject, int m_lastVisibleColInx, ExcelListener a_listener) {
        super.createNewFile(a_strFilename, a_msAnnotationDataObject, m_lastVisibleColInx, a_listener);
        this.m_images = new ArrayList<Picture>();
    }

    protected MSGlycanAnnotationTableDataObject getMyTableDataObject() {
        return (MSGlycanAnnotationTableDataObject)this.getAnnotationDataObject();
    }

    public void close() throws IOException {
        for (Picture t_picture : this.m_images) {
            t_picture.resize();
        }
        super.close();
    }

    public void writeRow(int _iRow, boolean _bIsHidden) {
        super.writeRow(_iRow, _bIsHidden);
    }

    protected void writeCell(Row _excelRow, ArrayList<Object> _tableRow, int _iDataColNum, int _iPrefColNum, boolean _bIsHidden) {
        if (_iPrefColNum < 0) {
            return;
        }
        if (_bIsHidden && _iDataColNum > this.m_lastVisibleColInx) {
            return;
        }
        if (this.getMyTableDataObject().getCartoonCols().contains(_iDataColNum)) {
            Object oCartoon = _tableRow.get(_iDataColNum);
            if (oCartoon == null) {
                super.writeCell(_excelRow, _tableRow, _iDataColNum, _iPrefColNum, _bIsHidden);
                return;
            }
            int iInx = this.getMyTableDataObject().getCartoonCols().indexOf(_iDataColNum);
            int iSeqColNum = (Integer)this.getMyTableDataObject().getSequenceCols().get(iInx);
            String sSequence = (String)_tableRow.get(iSeqColNum);
            this.writeCellImage(_excelRow, _tableRow, _iPrefColNum, sSequence);
        } else {
            super.writeCell(_excelRow, _tableRow, _iDataColNum, _iPrefColNum, _bIsHidden);
        }
    }

    protected void writeCellImage(Row _excelRow, ArrayList<Object> _tableRow, int _iPrefColNum, String _sSequence) {
        if (_iPrefColNum < 0 || _sSequence == null) {
            return;
        }
        try {
            GlycanImageProvider.GlycanImageObject gio = MSGlycanAnnotationTableDataObject.glycanImageProvider.getImage(_sSequence);
            this.helper.writeCellImage(this.m_objWorkbook, this.m_objSheet, this.m_iRowCounter, _iPrefColNum, gio.getAwtBufferedImage(), this.m_images);
        }
        catch (Exception e) {
            this.errorMessage("Image generation failed");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

