/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.editor.EntryEditorPart;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationResultsComposite;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecScansView;

public class MSAnnotationScansView
extends MassSpecScansView {
    private static final Logger logger = Logger.getLogger(MSAnnotationScansView.class);
    public static final String VIEW_ID = "plugin.ms.annotation.views.MSAnnotationScansView";

    @Inject
    public MSAnnotationScansView(Entry entry, Property msEntityProperty, @Named(value="MinMSLevelContext") int iMinMSLevel) {
        super(entry, msEntityProperty, iMinMSLevel);
    }

    public String toString() {
        return "MSAnnotationPeaksView (" + this.entry + ")";
    }

    protected void initResultsView(Composite parent) throws Exception {
        this.parent = parent.getParent().getParent();
        this.compositeTop = new Composite(parent, 2048);
        this.compositeTop.setLayout((Layout)new GridLayout(1, false));
        try {
            this.resultsComposite = this.getNewResultsComposite(this.compositeTop, 0);
            ((MSAnnotationResultsComposite)this.resultsComposite).createPartControl(this.compositeTop, (EntryEditorPart)this, this.entityProperty, this.dataProcessor, FillTypes.Scans);
            this.resultsComposite.setLayout((Layout)new FillLayout());
            this.viewBase = this.resultsComposite.getBaseView();
        }
        catch (Exception e) {
            this.viewBase = null;
            this.resultsComposite = null;
            logger.error((Object)"Error in MSAnnotationScansView: initResultsView");
            throw new Exception(e.getMessage());
        }
    }

    protected MSAnnotationResultsComposite getNewResultsComposite(Composite composite, int style) {
        return new MSAnnotationResultsComposite(composite, style);
    }

    protected TableDataProcessor getNewTableDataProcessor(Entry entry, Property entityProperty) {
        MSAnnotationTableDataProcessor proc = new MSAnnotationTableDataProcessor(entry, entityProperty, FillTypes.Scans, this.getMinMSLevel());
        proc.initializeTableDataObject(entityProperty);
        return proc;
    }

    protected TableDataProcessor getNewTableDataProcessor(Property entityProperty) {
        MSAnnotationMultiPageViewer parentViewer = MSAnnotationMultiPageViewer.getActiveViewerForEntry(this.context, this.getEntry().getParent());
        if (parentViewer == null || parentViewer.getScansView() == null) {
            return null;
        }
        TableDataProcessor parentProc = parentViewer.getScansView().getTableDataProcessor();
        MSAnnotationTableDataProcessor proc = new MSAnnotationTableDataProcessor(parentProc, entityProperty, FillTypes.Scans, this.getMinMSLevel());
        proc.initializeTableDataObject(entityProperty);
        return proc;
    }
}

