/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.swtchart.IAxisSet;
import org.swtchart.ILegend;
import org.swtchart.ISeriesSet;
import org.swtchart.ITitle;
import org.swtchart.internal.ChartLayout;
import org.swtchart.internal.ChartLayoutData;
import org.swtchart.internal.ChartTitle;
import org.swtchart.internal.Legend;
import org.swtchart.internal.PlotArea;
import org.swtchart.internal.Title;
import org.swtchart.internal.axis.AxisSet;
import org.swtchart.internal.series.SeriesSet;

public class Chart
extends Composite
implements Listener {
    private Title title;
    private Legend legend;
    private AxisSet axisSet;
    private PlotArea plotArea;
    private int orientation = 256;
    private boolean compressEnabled = true;
    private boolean updateSuspended = false;

    public Chart(Composite parent, int style) {
        super(parent, style | 0x20000000);
        parent.layout();
        this.setLayout(new ChartLayout());
        this.title = new ChartTitle(this);
        this.title.setLayoutData(new ChartLayoutData(-1, 100));
        this.legend = new Legend(this, 0);
        this.legend.setLayoutData(new ChartLayoutData(200, -1));
        this.plotArea = new PlotArea(this, 0);
        this.axisSet = new AxisSet(this);
        this.updateLayout();
        this.addListener(11, this);
    }

    public ITitle getTitle() {
        return this.title;
    }

    public ILegend getLegend() {
        return this.legend;
    }

    public IAxisSet getAxisSet() {
        return this.axisSet;
    }

    public Composite getPlotArea() {
        return this.plotArea;
    }

    public ISeriesSet getSeriesSet() {
        return this.plotArea.getSeriesSet();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        for (Control child : this.getChildren()) {
            if (child instanceof PlotArea || child instanceof Legend) continue;
            child.setBackground(color);
        }
    }

    public Color getBackgroundInPlotArea() {
        return this.plotArea.getBackground();
    }

    public void setBackgroundInPlotArea(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.plotArea.setBackground(color);
    }

    public void setOrientation(int orientation) {
        if (orientation == 256 || orientation == 512) {
            this.orientation = orientation;
        }
        this.updateLayout();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void enableCompress(boolean enabled) {
        this.compressEnabled = enabled;
    }

    public boolean isCompressEnabled() {
        return this.compressEnabled;
    }

    public void suspendUpdate(boolean suspend) {
        if (this.updateSuspended == suspend) {
            return;
        }
        this.updateSuspended = suspend;
        if (!suspend) {
            this.updateLayout();
            ((SeriesSet)this.getSeriesSet()).updateStackAndRiserData();
        }
    }

    public boolean isUpdateSuspended() {
        return this.updateSuspended;
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 11: {
                this.updateLayout();
                this.redraw();
                break;
            }
        }
    }

    public void updateLayout() {
        if (this.updateSuspended) {
            return;
        }
        if (this.legend != null) {
            this.legend.updateLayoutData();
        }
        if (this.title != null) {
            this.title.updateLayoutData();
        }
        if (this.axisSet != null) {
            this.axisSet.updateLayoutData();
        }
        this.layout();
        if (this.axisSet != null) {
            this.axisSet.refresh();
        }
    }

    public void update() {
        super.update();
        for (Control child : this.getChildren()) {
            child.update();
        }
    }

    public void dispose() {
        this.title.dispose();
        this.legend.dispose();
        this.axisSet.dispose();
        this.plotArea.dispose();
        super.dispose();
    }

    public void redraw() {
        super.redraw();
        for (Control child : this.getChildren()) {
            child.redraw();
        }
    }

    public void save(String filename, int format) {
        Image image = new Image((Device)Display.getDefault(), this.getBounds());
        GC gc = new GC((Drawable)image);
        this.print(gc);
        gc.dispose();
        ImageData data = image.getImageData();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{data};
        loader.save(filename, format);
        image.dispose();
    }

    public void renderOffscreenImage(Image image) {
        GC gc = new GC((Drawable)image);
        this.print(gc);
        gc.dispose();
    }
}

